from pylab import *
from scipy import *

import controls


###############################################################
#
#  This example uses the same numbers as example 4-4
#  of Ogata "System Dynamics" Fourth Edition pages 117-119
#
###############################################################

#define the parameters
m = 0.1
b2 = 0.4
k1 = 6
k2 = 4

#create a TransferFunction instance
num = [b2,k2]
den = [m*b2,m*k2,(k1+k2)*b2,k1*k2]
tf = controls.TransferFunction(num, den)


######################################
#
#  Laplace analysis of step response
#
######################################
P = controls.Input(10,[1,0])
X = tf*P
r,p,k = X.residue()
tflist = X.PartFrac()
print('r='+str(r))
print('p='+str(p))
print('k='+str(k))
print('partial fraction expansion = \n'+str(tflist))


######################################
#
#  Plot the step responses of x(t) and y(t)
#  This is essentially example 4-6
######################################
num2 = [k2]
tf2 = controls.TransferFunction(num2, den)

tf.step_response(fignum=1, amp=10, plotu=False)
tf2.step_response(fignum=1, clear=False, amp=10, plotu=False)
legend(['$x(t)$', '$y(t)$'])
xlabel('Time (sec)')
ylabel('Outputs x and y')
title('Unit-Step Responses')
grid(1)

show()
