from pylab import *
from scipy import *

import controls


###############################################################
#
#  This example uses the same numbers as example 4-3
#  of Ogata "System Dynamics" Fourth Edition pages 114-117
#
###############################################################

#create a TransferFunction instance
tf = controls.TransferFunction([2,10],[1,2,10])

######################################
#
#  Laplace analysis of step response
#
######################################
U = controls.Input(1,[1,0])
Y = tf*U
r,p,k = Y.residue()
tflist = Y.PartFrac()
print('r='+str(r))
print('p='+str(p))
print('k='+str(k))
print('partial fraction expansion = \n'+str(tflist))


######################################
#
# calculate the step response and plot it
# this is essentially example 4-5
#
######################################
y = tf.step_response(fignum=1, dt=0.01, maxt=8, step_time=0.5, plotu=1)
xlabel('Time (sec)')
ylabel('Output y')
title('Unit-Step Response')
grid(1)

show()
