// stock crap
import processing.opengl.*;
import controlP5.*;
ControlP5 controlP5;
ControlWindow controlWindow;
String delims = "[,]", delim = "[-]";
// paths for input files
String Bf ="/Users/msn/Documents/Processing/stocks5/data/B.csv";
String ITTf = "/Users/msn/Documents/Processing/stocks5/data/ITT.csv";
String QSIIf = "/Users/msn/Documents/Processing/stocks5/data/QSII.csv";
String[] files = new String[]{Bf, ITTf, QSIIf}; // array for paths for input files
PFont font;
float xC, yC, xOld, yOld, yNew;
// Datas is a 4-D array that hold all the data for the stocks
// it is of the form Datas[a][b][c][d]
// [a] is which stock is used
// [b] is whether we are dealing with the mapped or unmapped data
//     if it is [0], use the mapped data, if [1] use the unmapped data
// [c] is for whether we're using the regualr return data or the claculated daily return data
// [d] is for which day we're using
float [][][][] Datas=new float[3][2][2][365];
float [][][] RData=new float[3][5][365];
// xVals is for the x value, Return is the calcualted average return of the stock
float [] xVals=new float[365], Return =new float[3];
float [][] Risk=new float[3][3], temps=new float[3][365];
int [][] Volume=new int[3][365];
int count = 0, maxCount, i, DataToUse =0, GraphType = 0, j, k;
String [] dates=new String[365], temp=new String[365];
color[] colors={
  color(0,255,0), color(255,0,0), color(0,255,255)};
int xMouse;

void setup() {
  size(1000,800,OPENGL);
  background(0);
  controlP5 = new ControlP5(this);
  controlP5.setAutoDraw(false);
  controlWindow = controlP5.addControlWindow("controlP5window",100,100,170,200);
  controlWindow.setBackground(color(40));

  Controller Button1 = controlP5.addButton("B",10,10,10,80,40);
  Button1.setId(0);
  Button1.setWindow(controlWindow);

  Controller Button2 = controlP5.addButton("ITT",10,10,60,80,40);
  Button2.setId(1);
  Button2.setWindow(controlWindow);

  Controller Button3 = controlP5.addButton("QSII",10,10,110,80,40);
  Button3.setId(2);
  Button3.setWindow(controlWindow);

  Radio RadioButtons = controlP5.addRadio("radio",10,160);
  RadioButtons.add("Daily Info", 0);
  RadioButtons.add("Daily Return", 1);
  RadioButtons.setWindow(controlWindow);
  getData();
  statCalc();
}
void draw() {
  background(0);
  pushMatrix();
  font = loadFont("ComicSansMS-24.vlw");
  textFont(font);
  if (DataToUse == 0) {
    fill(colors[DataToUse]);
    text("Barnes Group Inc. (B)",375,30);
  } 
  else if (DataToUse == 1) {
    fill(colors[DataToUse]);
    text("ITT Corporation (ITT)",375,30);  
  } 
  else {
    fill(colors[DataToUse]);
    text("Quality Systems Inc. (QSII)",375,30);  
  }
  popMatrix();
  translate(50,50);
  strokeWeight(1);
  grid(0,0,800,700,10,80);
  if (GraphType == 0) {
    stroke(colors[DataToUse]);
    for (i=2; i<maxCount;i++) {
      ellipse(int(xVals[i]),int(700-Datas[DataToUse][0][0][i]),2,2);
      line(xVals[i-1],700-Datas[DataToUse][0][0][i-1],xVals[i],700-Datas[DataToUse][0][0][i]);
    }
    stroke(255,255,0,175);
    if (mouseX <50) {
      xMouse = 1;
    } 
    else if (mouseX >=850) {
      xMouse = maxCount-1;
    }
    else{
      xMouse = int(map(mouseX,50,850,1,maxCount));
      line(mouseX-50,(700-Datas[DataToUse][0][0][xMouse]),mouseX-50,700);
      line(mouseX-50,700-Datas[DataToUse][0][0][xMouse],0,700-Datas[DataToUse][0][0][xMouse]);
      stroke(0,255,255);
      fill(255);
   /*   font = loadFont("ComicSansMS-12.vlw");
      textFont(font);
      String t = "("+dates[xMouse]+","+Datas[DataToUse][1][0][xMouse]+")\n return="+Return[DataToUse]+"\n risk ="+Risk[DataToUse][DataToUse];
      text(t,mouseX-35,mouseY-30);*/
    }
  }
  if (GraphType == 1) {
    translate(0,350);
    stroke(colors[DataToUse]);
    for (i=2; i<maxCount;i++) {
      line(xVals[i],0.0,xVals[i],-Datas[DataToUse][0][1][i]);
    }
    stroke(255,255,0,175);
    if (mouseX <50) {
      xMouse = 1;
    } 
    else if (mouseX >850) {
      xMouse = maxCount-1;
    }
    else{
      xMouse = int(map(mouseX,50,850,1,maxCount));
      line(mouseX-50,(-Datas[DataToUse][0][1][xMouse]),mouseX-50,350);
      line(mouseX-50,-Datas[DataToUse][0][1][xMouse],0,-Datas[DataToUse][0][1][xMouse]);
      stroke(0,255,255);
      fill(255);
   /*   font = loadFont("ComicSansMS-12.vlw");
      textFont(font);
      String t = "("+dates[xMouse]+","+Datas[DataToUse][1][1][xMouse]+")\n return="+Return[DataToUse]+"\n risk ="+Risk[DataToUse][DataToUse];
      text(t,mouseX-35,mouseY-400);*/
    }
  }
  dataTable(xMouse);
}

void getData() {
  float y1s, y2s;
  int j;
  count = 0;
  try{
    BufferedReader in = new BufferedReader(new FileReader(files[DataToUse]));
    String s;
    while((s = in.readLine()) != null){
      count ++;
    }
    in.close();  
    maxCount = count-1;
  }
  catch (Throwable e){
    println(e);
  }
  for (j=0;j<3;j++) {
    count = maxCount;
    try{
      BufferedReader in = new BufferedReader(new FileReader(files[j]));
      String s;
      while((s = in.readLine()) != null){
        String[] tokens = s.split(delims);
        if (count == maxCount) {
          String dummy = String.valueOf(tokens[0].trim());
          count--;
        } 
        else {
          String date = String.valueOf(tokens[0].trim());
          float y = Float.valueOf(tokens[6].trim()).floatValue();
          float x1 = Float.valueOf(tokens[1].trim()).floatValue();
          float x2 = Float.valueOf(tokens[2].trim()).floatValue();
          float x3 = Float.valueOf(tokens[3].trim()).floatValue();
          float x4 = Float.valueOf(tokens[4].trim()).floatValue();
          int x5 = Integer.valueOf(tokens[5].trim()).intValue();
          xVals[count] = map(count,0,maxCount,0,800);
          temp[count] = date;
          Datas[j][0][0][count] = map(y,0.0,70.0,0.0,700.0);
          Datas[j][1][0][count] = y;
          RData[j][0][count] = x1;
          RData[j][1][count] = x2;
          RData[j][2][count] = x3;
          RData[j][3][count] = x4;
          Volume[j][count] = x5;
          yOld = y;
          count --;
        }
      }
      in.close(); 
    }
    catch (Throwable e){
      println(e);
    }
  }
  for (i=0;i<maxCount;i++) {
    String[] tokens = temp[i].split(delim);
    String xx = String.valueOf(tokens[1].trim());
    String yy = String.valueOf(tokens[2].trim());
    String zz = String.valueOf(tokens[0].trim());
    String dd = xx+"/"+yy+"/"+zz;
    dates[i]=dd;
  }  
  for (i=0;i<=2;i++) {
      for (j=1;j<maxCount;j++) {
      Datas[i][1][1][j] = (Datas[i][1][0][j]-Datas[i][1][0][j-1])/Datas[i][1][0][j-1];
      Datas[i][0][1][j] = map(Datas[i][1][1][j],-0.2,0.2,-350,350);
    }
  }
}
void statCalc() {
  int i,j,k;
  float sum, dev;
  for (i=0;i<3;i++) {
    sum = 0.0;
    for (j=0;j<=maxCount;j++) {
      sum = sum + Datas[i][1][1][j];
   }
   sum = sum / maxCount;
    //println(sum);
    Return[i] = sum;
  }
  for (j=0;j<=2;j++) {
    for (k=0;k<=2;k++) {
      dev = 0.0;
      for (i=0;i<=maxCount;i++) {  
        dev = dev + ((Datas[j][1][1][i] - Return[j]) * (Datas[k][1][1][i] - Return[k]));
      }
      dev = 1.0/(maxCount) * dev;
      Risk[j][k] = sqrt(dev);
      if (j==k) {
        //println(Risk[j][k]);
      }
    }
  }
}
void grid(int x, int y, int w, int h, int n, color c) {
  stroke(c);
  for (int ix=x; ix <= x+w; ix += n) {
    line(ix, y, ix, y+h);
  }
  for (int iy=y; iy <= y+h; iy += n) {
    line(x, iy, x+w, iy);
  }
  fill(255);
  stroke(255,255,255,255);
  font = loadFont("ComicSansMS-12.vlw");
  textFont(font);
  for (int ix=x; ix < x+w; ix +=40) {
    int iix;
    iix = floor(map(ix,x,x+w,1,maxCount));
    line(ix,h,ix,(h+10));
    String[] tokens = dates[iix].split("[/]");
    String xx = String.valueOf(tokens[0].trim());
    String yy = String.valueOf(tokens[1].trim());
    String dd = xx+"/"+yy;
    text(dd,(ix-10),(h+23)); 
  }
  if (GraphType == 0) {
    for (int iy=y; iy<=y+h;iy += 20) {
      int iiy;
      line(x,iy,(x-10),iy);
      iiy=floor(map(iy,y,y+h,0,70));
      text(iiy,(x-35),(h+3-iy)); 
    }
  } 
  else {
    for (int iy=y; iy<=y+h;iy += 20) {
      float iiy;
      line(x,iy,(x-10),iy);
      iiy = map(iy,y,y+h,-0.2,0.2);
      text(iiy,(x-47),(h+3-iy)); 
    }
  }
}

void dataTable(int val) {
  int x1,x2,y,h;
  x1=810;
  x2=875;
  h=15;
  //println(val);
  if (GraphType == 0) {
    y=10;
  } else {
    y=-340;
  }
  stroke(255);
  strokeWeight(2);
  line(x1-5,y-2*h-2,x1-5,y+8*h+5);
  line(x2+4*h+10,y-2*h-2,x2+4*h+10,y+8*h+5);
  line(x1-5,y-2*h-2,x2+4*h+10,y-2*h-2);
  line(x1-5,y+8*h+5,x2+4*h+10,y+8*h+5);
  font = loadFont("ComicSansMS-14.vlw");
  textFont(font);
  text(dates[val],x1+15,y-h);
  text("Open",x1,y);
  text(RData[DataToUse][0][val],x2,y);
  text("High",x1,y+h);
  text(RData[DataToUse][1][val],x2,y+h);
  text("Low",x1,y+2*h);
  text(RData[DataToUse][2][val],x2,y+2*h);
  text("Close",x1,y+3*h);
  text(RData[DataToUse][3][val],x2,y+3*h);
  text("Volume",x1,y+4*h);
  text(Volume[DataToUse][val],x2+2,y+4*h);
  text("Adj. Close",x1,y+5*h);
  text(Datas[DataToUse][1][0][val],x2,y+5*h);
  text("Daily Ret.",x1,y+6*h);
  text(Datas[DataToUse][1][1][val],x2,y+6*h);
  text("Return",x1,y+7*h);
  text(Return[DataToUse],x2,y+7*h);
  text("Mean Risk",x1,y+8*h);
  text(Risk[DataToUse][DataToUse],x2,y+8*h);
  // Directions on how to use
  x1=805;
  text("Use this program to", x1,y+10*h);
  text("see how stock move",x1,y+11*h);
  text("from day to day",x1,y+12*h);
  text("Move your mouse",x1,y+13*h);
  text("around the grid",x1,y+14*h);
  text("To see that day's",x1,y+15*h);
  text("values for that stock",x1,y+16*h);
  text("The Daily Info view",x1,y+17*h);
  text("shows the adjusted",x1,y+18*h);
  text("close price graphed",x1,y+19*h);
  text("against date. The",x1,y+20*h);
  text("Daily Risk view shows",x1,y+21*h);
  text("the daily return,",x1,y+22*h);
  text("which is calculated by",x1,y+23*h);
  text("(y_n-y_{n-1})/y_{n-1}",x1,y+24*h);
  text("where y_n is that",x1,y+25*h);
  text("day's adjusted close",x1,y+26*h);
  text("and y_{n-1} is the",x1,y+27*h);
  text("previous day's",x1,y+28*h);
  text("adjusted close.",x1,y+29*h);
  text("Use the buttons",x1,y+30*h);
  text("labeld 'B', 'ITT',",x1,y+31*h);
  text("and 'QSII' to change",x1,y+32*h);
  text("which stock is shown",x1,y+33*h);
}

void controlEvent(ControlEvent theEvent){
  if(theEvent.controller().id() == 0)//Earth view
  {
    DataToUse = 0;
  }
  else if(theEvent.controller().id() == 1)//Space View
  {
    DataToUse = 1;
  } 
  else if(theEvent.controller().id() == 2)//Space View
  {
    DataToUse = 2;
  }
}
void radio(int theID){
  switch(theID){
    case(0):
    GraphType = 0;
    break;
    case(1):
    GraphType = 1;
    break;
  }
}
