%------------------------------%
% Extract Solution from Output %
%------------------------------%
solution = output.result.solution;
time = solution.phase(1).time;
r         = solution.phase(1).state(:,1);
theta     = solution.phase(1).state(:,2);
u         = solution.phase(1).state(:,3);
v         = solution.phase(1).state(:,4);
if output.result.setup.auxdata.use_angular_control,
    alpha = solution.phase(1).control(:,1);
else
    w1        = solution.phase(1).control(:,1);
    w2        = solution.phase(1).control(:,2);
    alpha     = atan2(w1,w2)*180/pi;
end
%---------------%
% Plot Solution %
%---------------%
figure(1)
pp = plot(time,r,'-o');
xl = xlabel('$t$','Interpreter','LaTeX');
yl = ylabel('$r(t)$','Interpreter','LaTeX');
set(xl,'FontSize',18);
set(yl,'FontSize',18);
set(gca,'FontSize',16,'FontName','Times');
set(pp,'LineWidth',1.25);
grid on

figure(2)
pp = plot(time,theta,'-o');
xl = xlabel('$t$','Interpreter','LaTeX');
yl = ylabel('$\theta(t)$','Interpreter','LaTeX');
set(xl,'FontSize',18);
set(yl,'FontSize',18);
set(gca,'FontSize',16,'FontName','Times');
set(pp,'LineWidth',1.25);
grid on

figure(4)
pp = plot(time,u,'-o');
xl = xlabel('$t$','Interpreter','LaTeX');
yl = ylabel('$u(t)$','Interpreter','LaTeX');
set(xl,'FontSize',18);
set(yl,'FontSize',18);
set(gca,'FontSize',16,'FontName','Times');
set(pp,'LineWidth',1.25);
grid on

figure(5)
pp = plot(time,v,'-o');
xl = xlabel('$t$','Interpreter','LaTeX');
yl = ylabel('$v(t)$','Interpreter','LaTeX');
set(xl,'FontSize',18);
set(yl,'FontSize',18);
set(gca,'FontSize',16,'FontName','Times');
set(pp,'LineWidth',1.25,'MarkerSize',8);
grid on

if output.result.setup.auxdata.use_angular_control,
    figure(6);
    pp = plot(time,alpha,'-o');
    xl = xlabel('$t$','Interpreter','LaTeX');
    yl = ylabel('$\alpha(t)$','Interpreter','LaTeX');
    set(xl,'FontSize',18);
    set(yl,'FontSize',18);
    set(gca,'FontSize',16,'FontName','Times');
    set(gca,'FontSize',16);
    set(pp,'LineWidth',1.25);
    grid on
else
    figure(6);
    pp = plot(time,w1,'-o',time,w2,'-d');
    xl = xlabel('$t$','Interpreter','LaTeX');
    yl = ylabel('$(w_1(t),w_2(t))$','Interpreter','LaTeX');
    set(xl,'FontSize',18);
    set(yl,'FontSize',18);
    set(gca,'FontSize',16,'FontName','Times');
    set(gca,'FontSize',16);
    set(pp,'LineWidth',1.25);
    grid on
    figure(7);
    pp = plot(time,alpha,'-o');
    xl = xlabel('$t$','Interpreter','LaTeX');
    yl = ylabel('$\alpha(t)$','Interpreter','LaTeX');
    set(xl,'FontSize',18);
    set(yl,'FontSize',18);
    set(gca,'FontSize',16,'FontName','Times');
    set(gca,'FontSize',16);
    set(pp,'LineWidth',1.25);
    grid on

end