function phaseout = orbitRaisingContinuous(input)

% input
% input.phase(phasenumber).state
% input.phase(phasenumber).control
% input.phase(phasenumber).time
% input.phase(phasenumber).parameter
%
% input.auxdata = auxiliary information
%
% output
% phaseout(phasenumber).dynamics
% phaseout(phasenumber).path
% phaseout(phasenumber).integrand
 
T  = input.auxdata.T;
ve = input.auxdata.ve;
mu = input.auxdata.mu;

t     = input.phase.time;
r     = input.phase.state(:,1);
theta = input.phase.state(:,2);
u     = input.phase.state(:,3);
v     = input.phase.state(:,4);
m     = input.phase.state(:,5);
if input.auxdata.use_angular_control,
    alpha = input.phase.control(:,1);
    w1 = sin(alpha);
    w2 = cos(alpha);
else
    w1    = input.phase.control(:,1);
    w2    = input.phase.control(:,2);
end

rdot      = u;
thetadot  = v./r;
udot      = v.^2./r-mu./r.^2+(T./m).*w1;
vdot      = -u.*v./r+(T./m).*w2;
mdot      = -(T/ve)*ones(size(t));

phaseout.dynamics  = [rdot, thetadot, udot, vdot, mdot];
if ~input.auxdata.use_angular_control,
    phaseout.path = w1.^2 + w2.^2;
end
