solution = output.result.solution;

for p=1:3
    t{p} = solution.phase(p).time;
    h{p} = solution.phase(p).state(:,1)/1000;
    v{p} = solution.phase(p).state(:,2);
    m{p} = solution.phase(p).state(:,3);
    T{p} = solution.phase(p).control(:,1);
end

figure(1);
pp = plot(t{1},h{1},'-o',t{2},h{2},'-d',t{3},h{3},'-s');
xl = xlabel('$t$~(s)');
yl = ylabel('$h(t)$~(km)');
ll = legend('Phase 1 (Maximum Thrust)','Phase 2 (Singular Arc)','Phase 3 (Minimum Thrust)','Location','SouthEast');
set(pp,'LineWidth',1.5);
set(xl,'Interpreter','LaTeX','FontSize',16);
set(yl,'Interpreter','LaTeX','FontSize',16);
set(ll,'Interpreter','LaTeX','FontSize',16);
set(gca,'FontName','Times','FontSize',16);
grid on

figure(2);
pp = plot(t{1},v{1},'-o',t{2},v{2},'-d',t{3},v{3},'-s');
xl = xlabel('$t$~(s)');
yl = ylabel('$v(t)$~(m$\cdot$s${}^{-1}$)');
ll = legend('Phase 1 (Maximum Thrust)','Phase 2 (Singular Arc)','Phase 3 (Minimum Thrust)','Location','Best');
set(pp,'LineWidth',1.5);
set(xl,'Interpreter','LaTeX','FontSize',16);
set(yl,'Interpreter','LaTeX','FontSize',16);
set(ll,'Interpreter','LaTeX','FontSize',16);
set(gca,'FontName','Times','FontSize',16);
grid on

figure(3);
pp = plot(t{1},m{1},'-o',t{2},m{2},'-d',t{3},m{3},'-s');
xl = xlabel('$t$~(s)');
yl = ylabel('$m(t)$~(kg)');
ll = legend('Phase 1 (Maximum Thrust)','Phase 2 (Singular Arc)','Phase 3 (Minimum Thrust)','Location','NorthEast');
set(pp,'LineWidth',1.5);
set(xl,'Interpreter','LaTeX','FontSize',16);
set(yl,'Interpreter','LaTeX','FontSize',16);
set(ll,'Interpreter','LaTeX','FontSize',16);
set(gca,'FontName','Times','FontSize',16);
grid on

figure(4);
pp = plot(t{1},T{1},'-o',t{2},T{2},'-d',t{3},T{3},'-s');
xl = xlabel('$t$~(s)');
yl = ylabel('$T(t)$~(N)');
ll = legend('Phase 1 (Maximum Thrust)','Phase 2 (Singular Arc)','Phase 3 (Minimum Thrust)','Location','NorthEast');
set(pp,'LineWidth',1.5);
set(xl,'Interpreter','LaTeX','FontSize',16);
set(yl,'Interpreter','LaTeX','FontSize',16);
set(ll,'Interpreter','LaTeX','FontSize',16);
set(gca,'FontName','Times','FontSize',16);
grid on
