function output = goddardRocketEndpoint(input);

g             = input.auxdata.g;
sigma         = input.auxdata.sigma;
H             = input.auxdata.H;
c             = input.auxdata.c;

p = 1;
tf{p} = input.phase(p).finaltime;
hf{p} = input.phase(p).finalstate(1);
vf{p} = input.phase(p).finalstate(2);
mf{p} = input.phase(p).finalstate(3);

p = 2;
t0{p} = input.phase(p).initialtime;
h0{p} = input.phase(p).initialstate(1);
v0{p} = input.phase(p).initialstate(2);
m0{p} = input.phase(p).initialstate(3);
tf{p} = input.phase(p).finaltime;
hf{p} = input.phase(p).finalstate(1);
vf{p} = input.phase(p).finalstate(2);
mf{p} = input.phase(p).finalstate(3);

output.eventgroup(1).event = [tf{p-1}-t0{p},hf{p-1}-h0{p},vf{p-1}-v0{p},mf{p-1}-m0{p}];

output.eventgroup(3).event = m0{2}*g-(1+v0{p}/c)*sigma*v0{2}^2*exp(-h0{2}/H);

p = 3;
t0{p} = input.phase(p).initialtime;
h0{p} = input.phase(p).initialstate(1);
v0{p} = input.phase(p).initialstate(2);
m0{p} = input.phase(p).initialstate(3);
tf{p} = input.phase(p).finaltime;
hf{p} = input.phase(p).finalstate(1);
vf{p} = input.phase(p).finalstate(2);
mf{p} = input.phase(p).finalstate(3);

output.eventgroup(2).event = [tf{p-1}-t0{p},hf{p-1}-h0{p},vf{p-1}-v0{p},mf{p-1}-m0{p}];

output.objective = -hf{3};

