function output = goddardRocketContinuous(input)

g     = input.auxdata.g;
sigma = input.auxdata.sigma;
c     = input.auxdata.c;
H     = input.auxdata.H;

% Variables in Phase 1
p    = 1;
t{p} = input.phase(p).time;
h{p} = input.phase(p).state(:,1);
v{p} = input.phase(p).state(:,2);
m{p} = input.phase(p).state(:,3);
T{p} = input.phase(p).control(:,1);

% Differential Equations in Phase 1
hdot{p} = v{p};
vdot{p} = (T{p} - sigma*v{p}.^2.*exp(-h{p}/H))./m{p} - g;
mdot{p} = -T{p}./c;

output(p).dynamics = [hdot{p},vdot{p},mdot{p}];

% Variables in Phase 2
p    = 2;
t{p} = input.phase(p).time;
h{p} = input.phase(p).state(:,1);
v{p} = input.phase(p).state(:,2);
m{p} = input.phase(p).state(:,3);
T{p} = input.phase(p).control(:,1);

% Differential Equations in Phase 2
hdot{p} = v{p};
vdot{p} = (T{p} - sigma*v{p}.^2.*exp(-h{p}/H))./m{p} - g;
mdot{p} = -T{p}./c;

path2 = T{p}-sigma*v{p}.^2.*exp(-h{p}/H)-m{2}.*g-m{2}.*g./(1+4.*(c./v{p})+2.*(c./v{p}).^2).*(c.^2./(H*g).*(1+v{p}./c)-1-2.*(c./v{p}));

output(p).dynamics = [hdot{p},vdot{p},mdot{p}];
output(p).path = path2;

% Variables in Phase 3
p    = 3;
t{p} = input.phase(p).time;
h{p} = input.phase(p).state(:,1);
v{p} = input.phase(p).state(:,2);
m{p} = input.phase(p).state(:,3);
T{p} = input.phase(p).control(:,1);

% Differential Equations in Phase 3
hdot{p} = v{p};
vdot{p} = (T{p} - sigma*v{p}.^2.*exp(-h{p}/H))./m{p} - g;
mdot{p} = -T{p}./c;

output(p).dynamics = [hdot{p},vdot{p},mdot{p}];
