% params.m
%
% for opt_lotka_volterra.m
%

% choosing mode & solution method
mode   = 'OPT';                  % OPT or TEST
method = 'BFGS';                 % SD, CG, BFGS
BFGSrst = 5;                     % restart parameter for BFGS

% MODEL parameters:
% t-domain
ti = 0; tf = 15;                 % t-domain
Nt = 100;                        % number of discrete intervals in t-domain
% x-solution
x1i = 50.0; x2i = 50.0;          % initial conditions for LV-IVP
% coefficients in the main LV-ODE system
paramsODE = [1.0 0.01 1.0 0.02]; % alpha, beta, gamma, delta
modelU = 2;                      % exact u(t) model number (1, 2, 3, 4)

% OPT setup:
objWeight = [1.0 1.0];           % weight coefficients in objective
u_ini = 0.5;                     % initial guess for u(t) - constant
u_l = 0.0; u_u = 1.0;            % lower and upper bounds for control (for later use)

% [SD, CG, BFGS] - parameters for alpha stepsize search
% (1) Golden Section GS, (2) bracketing-Brent BB toolbox
methodAlpha = 'BB';              % method for alpha stepsize search: GS, BB
% (1) GS
alphaA = 0; alphaB = 1e-6;       % search interval [a, b]
alphaEps = 1e-9;                 % tolerance for search termination
% (2) bracketing-Brent toolbox
brackA = 0; brackB = 1e-6;       % min_brack: initial bracketing interval [a, b]
MAXITER = 20;                    % min_brack: max number of iterations
GLIMIT = 100.0;                  % min_brack: maximum magnification allowed for parabolic-fit step
TOL = 1e-9;                      % Brent: tolerance
ITMAX = 2;                       % Brent: max number of iterations

% termination
epsilonF = 1e-9;                 % tolerance (#1) relative objective decrease
epsilonA = 1e-9;                 % tolerance (#2) relative solution decrease
kMax     = 200;                  % max number of iterations (#3)

% visualization parameters
BigFigure       = true;
FontSize        = 12;
MarkerSizeBig   = 30;
MarkerSizeSmall = 15;
LineWidth       = 2.5;
pauseTime       = 0;             % pause time (in seconds)
