% opt_lotka_volterra.m
%
% MTH6300: Numerical Optimization
% Dynamics of Biological Systems by Lotka-Volterra Equations
%
% Full optimization solver for the Lotka-Volterra (LV) predator-prey model:
%    * Matlab ODE solvers ode23 & ode45 are used to solve the forward
%      and adjoint problems
%    * control variable u(t) is set as exact function using then
%      synthetic measurements
%    * measurements x1*(t) & x2*(t) are continuous functions
%
% Solver includes:
% - modes:   regular OPT & TEST (for gradient-based approaches)
% - methods (gradient-based only):
%          * Steepest Descent (SD)
%          * Conjugate Gradient (CG)
%          * quasi-Newton (BFGS)
% - stepsize methods:
%          * Golden Section (GS) Search
%          * bracketing-Brent toolbox (BB)
% - output:  functional value (in file)
%
% Vladislav Bukshtynov, FIT 2018

close all; clear all; clc; tic;

% setting INPUT parameters
params;

% paths for supplemental MATLAB codes
addpath algorithms;                % algorithms for main code
addpath functions;                 % m-functions
addpath functions/Lotka_Volterra;  % Lotka-Volterra functions

% INItialization
initialize;

% creating analytic/synthetic measurements
measurements;

% choosing mode
if strcmp(mode,'OPT')
  mode_OPT;
elseif strcmp(mode,'TEST')
  mode_TEST;
else
  disp(['error: Unknown mode ' mode ' is chosen!']); return;
end

% final output
if (exCode==0)
  return;
elseif strcmp(mode,'OPT')
  output_final;
  output_file;
  fprintf(['Terminated in ' num2str(k) ' iteration(s): termination condition #' num2str(exCode) ' satisfied!\n']);
end
fprintf(['We are fully done! CPU elapsed time = ' num2str(toc) 's\n\n']);
