% fn_min_brack.m
%
% MTH6300: Numerical Optimization
%
% 'fn_min_brack.m' - this function performs initial bracketing of the minimum
%
% ------------------------------------------------------------------------
%                        Bracketing routine
% ------------------------------------------------------------------------
% The calling convention of this function is slightly modified from that
% in Numerical Recipies.  Also, it assumes that the minimum is in the direction
% of BX from AX, so the routine will not explore to the other side of BX!
% Note that this gets caught in an endles loop if this direction is uphill!
%
% INPUT:
%   AX, BX are initial guesses of X which might bracket the minimum,
%   FA, FB must be provided as the initial function values at points AX, BX
%
% Update made by Bartek Protas on the 02nd Feb. 2001:
%   MAXITER - maximum allowed number of iterations. If the maximum number
%   of iterations is exceeded without bracketing the minimum, the function 
%   returns CX = BX = AX.
%
% OUTPUT:
%    AX, BX, and CX bracket the minimum point, with function values of
%    FA, FB, and FC respectively
% ------------------------------------------------------------------------
%
% Vladislav Bukshtynov, FIT 2018

function [AX, FA, BX, FB, CX, FC] = fn_min_brack(AX,BX,FA,FB,FUNC,MAXITER,GLIMIT)

GOLD=1.618034; GOLDINV = 1.0/(1.0+GOLD); TINY=1.E-20;
CX=0.0; ICOUNT=0;

while (FB > FA) 
  if (ICOUNT <= 8)
    CX = BX;
    FC = FB;
    BX = GOLDINV * (CX + GOLD*AX);
    FB = FUNC(BX);
    FB = FB(1);
    ICOUNT = ICOUNT + 1;
  else
    disp('Oops - it appears as if I am proceeding uphill.')
    disp('I will now use a safer bracketing procedure.')
    DUM = AX;
    AX = BX;
    BX = DUM;
    DUM = FB;
    FB = FA;
    FA = DUM;
    CX = 0.0;
  end;
end;

if (CX == 0.0)
%The following factor of GOLD was reduced to (GOLD-1.) to save one function
%evaluation near convergence.
  CX = BX + (GOLD-1.0) * (BX-AX);
  FC = FUNC(CX);
  FC = FC(1);
%%/////////////////////////////////////////////////////////////////////////
%%///// Update made by Bartek Protas on the 02nd Feb. 2001 ////////////////
  ICOUNT = ICOUNT + 1;
  if ( ICOUNT >= MAXITER ) 
    BX = AX;
    CX = AX;
    disp('Could not bracket the minimum! Bugging out ...')
    return;
  end;
%%/////////////////////////////////////////////////////////////////////////
end;

% here label = 1;
while ( FB >= FC ) 
  goto = 0;
  R = (BX-AX)*(FB-FC);
  Q = (BX-CX)*(FB-FA);
  U = BX-((BX-CX)*Q-(BX-AX)*R) / (2.*max(abs(Q-R),TINY)*sign(Q-R));
  ULIM = BX+GLIMIT*(CX-BX);
% this is stupid, but I couldn't figure out a different way to implement
% jumps out an IF-block.
  for dd=1:1; if ( ((BX-U) * (U-CX)) > 0.0 )
      FU = FUNC(U);

%%/////////////////////////////////////////////////////////////////////////
%%///// Update made by Bartek Protas on the 02nd Feb. 2001 ////////////////
    ICOUNT=ICOUNT+1;
    if ( ICOUNT >= MAXITER ) 
      BX = AX;
      CX = AX;
      disp('Could not bracket the minimum! Bugging out ...')
      return;
    end;
%%/////////////////////////////////////////////////////////////////////////
    goto = 0;
    if ( FU < FC )
      AX = BX;
      FA = FB;
      BX = U;
      FB = FU;
      goto = 1;
    elseif ( FU > FB )
      CX = U;
      FC = FU;
      goto = 1;
    end;
    if ( goto == 1 ); break; end;

    U = CX+GOLD*(CX-BX);
    FU = FUNC(U);

%%/////////////////////////////////////////////////////////////////////////
%%///// Update made by Bartek Protas on the 02nd Feb. 2001 ////////////////
    ICOUNT = ICOUNT+1;
    if ( ICOUNT >= MAXITER ) 
      BX = AX;
      CX = AX;
      disp('Could not bracket the minimum! Bugging out ...')
      return;
    end;
%%/////////////////////////////////////////////////////////////////////////
  elseif ( (CX-U)*(U-ULIM) > 0.0 ) 
      FU = FUNC(U);
%%/////////////////////////////////////////////////////////////////////////
%%///// Update made by Bartek Protas on the 02nd Feb. 2001 ////////////////
    ICOUNT = ICOUNT+1;
    if ( ICOUNT >= MAXITER ) 
      BX = AX;
      CX = AX;
      disp('Could not bracket the minimum! Bugging out ...')
      return;
    end;
%%/////////////////////////////////////////////////////////////////////////
    if ( FU < FC )
      BX = CX;
      CX = U;
      U = CX+GOLD*(CX-BX);
      FB = FC;
      FC = FU;
      FU = FUNC(U);
%%/////////////////////////////////////////////////////////////////////////
%%///// Update made by Bartek Protas on the 02nd Feb. 2001 ////////////////
      ICOUNT = ICOUNT+1;
      if ( ICOUNT >= MAXITER ) 
        BX = AX;
	CX = AX;
	disp('Could not bracket the minimum! Bugging out ..')
        return;
      end;
%%/////////////////////////////////////////////////////////////////////////
    end;
  elseif ( (U-ULIM)*(ULIM-CX) >= 0.0 )
    U = ULIM;
    FU = FUNC(U);
%%/////////////////////////////////////////////////////////////////////////
%%///// Update made by Bartek Protas on the 02nd Feb. 2001 ////////////////
    ICOUNT = ICOUNT+1;
    if ( ICOUNT >= MAXITER )
      BX = AX;
      CX = AX;
      disp('Could not bracket the minimum! Bugging out ...')
      return;
    end;
%%/////////////////////////////////////////////////////////////////////////
  else
    U = CX+GOLD*(CX-BX);
    FU = FUNC(U);
%%/////////////////////////////////////////////////////////////////////////
%%///// Update made by Bartek Protas on the 02nd Feb. 2001 ////////////////
    ICOUNT = ICOUNT+1;
    if ( ICOUNT >= MAXITER ) 
      BX = AX;
      CX = AX;
      disp('Could not bracket the minimum! Bugging out ...')
      return;
    end;
%%/////////////////////////////////////////////////////////////////////////
  end; end;
  if ( goto ~= 1 )  
    AX = BX;
    BX = CX;
    CX = U;
    FA = FB;
    FB = FC;
    FC = FU;
  end;

end;

return;
