% fn_eval_obj.m

function [obj,x1,x2] = fn_eval_obj(step, u, d, params, data)

  % updating solution  
  u = u + step*d;

  % solving numerically LV ODE using ode23
  [T X] = ode23(@(t,x) fn_Lotka_Volterra_fwd(t,x,params,data,u), data(:,1), params(5:6));

  % computing objective
  x1 = X(:,1); x2 = X(:,2);
  obj = params(7) * trapz(data(:,1), (x1 - data(:,2)).^2) + params(8) * trapz(data(:,1), (x2 - data(:,3)).^2);

return