% fn_eval_grad.m

function grad = fn_eval_grad(u, x, params, data)

  [T PSI] = ode23(@(t,psi) fn_Lotka_Volterra_adj(t, psi, params, data, u, x), ...
                  data(end:-1:1,1), [0 0]);

  % computing gradient - reverting time as AP is solved backward in time
  grad = x(:,1).*PSI(end:-1:1,1) + x(:,2).*PSI(end:-1:1,2);
  
return