% fn_brent.m
%
% MTH6300: Numerical Optimization
%
% 'fn_brent.m' - this function performs line minimization using Brent method
%
% ------------------------------------------------------------------------
%                       Line minimization routine
% ------------------------------------------------------------------------
% The calling convention of this function is slightly modified from that
% in Numerical Recipies:
%
% INPUT:
%   AX, BX, and CX are a bracketing triplet of points from fn_min_brack, and
%   FA, FB, FC must be provided as the initial function values at points AX, BX, CX
%   TOL is the accuracy of the final answer
%   ITMAX is maximum number of iterations
%
% OUTPUT:
%   FB is the minimum value of FUNC, at the minimum point BX
% ------------------------------------------------------------------------
%
% Vladislav Bukshtynov, FIT 2018

function [BX, FB] = fn_brent(AX,BX,CX,FA,FB,FC,FUNC,TOL,ITMAX)

CGOLD=0.3819660; ZEPS=1.0E-20; D=0.0;

% Storing the value corresponding to ALPHA=0.0; will need it below;
F0 = FA;
FW=min( FA, FC);
if (FW == FA) 
  W = AX;
  V = CX;
  FV = FC;
else
  W = CX;
  V = AX;
  FV= FA;
end
X = BX;
FX = FB;
A = min( AX, CX);
B = min( AX, CX);

for ITER=1:ITMAX
  goto = 0;
  if ( ITER <= 2 ) 
     E = 2.0 * (B-A);
  end;
  XM = 0.5 * (A+B);
  TOL1 = TOL * abs(X) + ZEPS;
  TOL2 = 2.0 * TOL1;
%%/////////////////////////////////////////////////////////////////////////
%%///// Update made by Bartek Protas on the 03rd Apr. 2001 ////////////////
%        IF(ABS(X-XM).LE.(TOL2-.5*(B-A))) GOTO 3
% Here we use the Wolfe's sufficient decrease condition combined with the original condition;
% The Wolfe's condition is temporarily turned off and the standard check is used;
%  if ( (FX <= (F0-CWolfe*X*GxP)) || (abs(X-XM) <= (TOL2-.5*(B-A))) ) 
  if ( abs(X-XM) <= (TOL2-.5*(B-A)) ) 
    goto = 3;
    break;
  end;
%%/////////////////////////////////////////////////////////////////////////
% this is stupid, but I could not figure out a different way to implement
% jumps out an IF-block.
  for dd=1:1; if ( (abs(E) > TOL1) || (ITER <= 2) ) 
    R = (X-W)*(FX-FV);
    Q = (X-V)*(FX-FW);
    P = (X-V)*Q-(X-W)*R;
    Q = 2.*(Q-R);
    if ( Q > 0.0) 
      P = -P;
    end;
    Q = abs(Q);
    ETEMP = E;
    E = D;
    if( (abs(P) >= abs(0.5*Q*ETEMP)) || (P <= Q*(A-X)) || (P >= Q*(B-X)) ) 
      goto = 1;
      break;
    end;
    D = P/Q;
    U = X+D;
    if ( ((U-A) <= TOL2) || ((B-U) <= TOL2) ) 
      D = TOL1 * sign(XM-X);
    end;
    goto = 2;
  end; end;

% here is label = 1;
  if ( goto ~= 2 )
    if ( X >= XM )
      E = A-X;
    else
      E = B-X;
    end;
    D = CGOLD * E;
  end;

% here is label = 2;
  if ( abs(D) >= TOL1 )
    U = X+D;
  else
    U = X+TOL1 * sign(D);
  end;      
    FU = FUNC(U);
    FU = FU(1);

    if (FU <= FX) 
    if (U >= X)
      A = X;
    else
      B = X;
    end;
    V = W;
    FV = FW;
    W = X;
    FW = FX;
    X = U;
    FX = FU;
  else
    if (U < X)
      A = U;
    else
      B = U;
    end;
    if ( (FU <= FW) || (W == X) ) 
      V = W;
      FV = FW;
      W = U;
      FW = FU;
    elseif ( (FU <= FV) || (V == X) || (V == W) ) 
        V = U;
	FV = FU;
    end;
  end;
end;
if ( goto == 0 )
  text = sprintf('No convergence in %d iterations',ITMAX);
  disp(text);
end;

BX = X;
FB = FX;
return;


