% fn_Lotka_Volterra_fwd.m
%
% Function: Lotka-Volterra Equations for Forward Problem
%
% Lotka-Volterra predator-prey model
%

function xp = fn_Lotka_Volterra_fwd(t, x, params, data, U)

  T = data(:,1);
  u = interp1(T, U, t); % interpolating data set (T, U) at times t

  % description of the system of ODEs
  xp = [(params(1) - params(2)*x(2) - u)*x(1); ...
       -(params(3) - params(4)*x(1) + u)*x(2)];

return