% fn_Lotka_Volterra_adj.m
%
% Function: Lotka-Volterra Equations for Adjoint Problem
%
% Lotka-Volterra predator-prey model
%

function psip = fn_Lotka_Volterra_adj(t, psi, params, data, U, X)

  % interpolating data sets U, X, X* at times t
  T = data(:,1);
  u = interp1(T, U, t);
  x1 = interp1(T, X(:,1), t);
  x2 = interp1(T, X(:,2), t);
  x1s = interp1(T, data(:,2), t);
  x2s = interp1(T, data(:,3), t);

  % description of the system of ODEs
  psip = [ 2*params(7)*(x1-x1s) - (params(1)-params(2)*x2)*psi(1) + u*psi(1) - params(4)*x2*psi(2); ...
           2*params(8)*(x2-x2s) + params(2)*x1*psi(1) + (params(3)-params(4)*x1)*psi(2) + u*psi(2)];

return