% visualize.m
%
% Visualization procedure for opt_lotka_volterra.m
%

figure(1);
if (BigFigure)
  set(gcf, 'Units', 'Normalized', 'OuterPosition', [0 0 1 1]);
end

% #1: objective function
subplot(2,2,1);
semilogy(0:k,obj,'b.-','MarkerSize',MarkerSizeSmall,'LineWidth',LineWidth-1); hold on;
title(['objective function (log-scaled), f = ' num2str(obj(end))],'FontSize',FontSize);
xlabel('iterations, k','FontSize',FontSize); set(gca,'FontSize',FontSize); box off;

% #2: optimal control u(t)
subplot(2,2,2);
plot(tt,u_ini,'--k', tt,u,'o-b', tt,u_ex,'.-r'); xlabel('t','FontSize',FontSize);
title(['control u(t): iteration #' num2str(k)],'FontSize',FontSize);
legend('u_{ini}(t)','u(t)','u_{ex}(t)','Location','Best'); legend boxoff;
set(gca,'FontSize',FontSize); box off; hold off;

% #3: solution x_1(t) & x_2(t)
subplot(2,2,3);
plot(tt,data(:,2),'.-b', tt,data(:,3),'.-m', tt,x1,'o-b', tt,x2,'o-m', tt,x10,'--b', tt,x20,'--m');
title('solution: x_1(t) & x_2(t)','FontSize',FontSize); xlabel('t','FontSize',FontSize);
legend('x_1(t)','x_2(t)','Location','Best'); legend boxoff;
set(gca,'FontSize',FontSize); box off; hold off;

% #4: gradient
if k>0
  subplot(2,2,4);
  plot(tt,-d,'.-b','MarkerSize',MarkerSizeSmall);
  xlabel('t','FontSize',FontSize); title('gradient','FontSize',FontSize);
  set(gca,'FontSize',FontSize); box off;
end

% make a pause
if pauseTime > 0
  pause(pauseTime);
end
