% search_stepsize.m
%
% Algorithm for finding optimal stepsize in line search by:
% - Golden Section (GS)
% - bracketing-Brent toolbox (BB)
%

switch methodAlpha
    
  case 'GS'
    golden_section_search;
    
  case 'BB'
    % initial bracketing guess
    AX = brackA; BX = brackB;
    FA = f(AX,u,d,params,data); FB = f(BX,u,d,params,data);
    % calling bracketing routine
    [AX,FA,BX,FB,CX,FC] = fn_min_brack(AX,BX,FA,FB,@(alphaCurr) FUNC(alphaCurr,u,d,f,params,data),MAXITER,GLIMIT);
    % calling minimization routine
    [BX,FB] = fn_brent(AX,BX,CX,FA,FB,FC,@(alphaCurr) FUNC(alphaCurr,u,d,f,params,data),TOL,ITMAX);
    alphaOpt = BX;

  otherwise
    disp(['error (OPT): Unknown stepsize search method ' methodAlpha ' is chosen!']);
    exCode = 0; % termination due to error
    return;

end

% check for divergence
if f(alphaOpt,u,d,params,data)>obj(end)
  alphaOpt = 0.0;
end
