% search_direction.m
%
% Algorithm for finding search direction using:
% - Steepest Descent (SD)
% - Conjugate Gradient (CG)
% - quasi-Newton (BFGS)
%

switch method
    
  case 'SD'
    d = -grad(u,[x1 x2],params,data);

  case 'CG'
    grad_curr = grad(u,[x1 x2],params,data);
    if (k==0)
      d = -grad_curr;
    else
      d = -grad_curr + (grad_curr'*grad_curr)/(grad_old'*grad_old)*d;
    end
    grad_old = grad_curr;

  case 'BFGS'
    if (rem(k,BFGSrst)==0)
      D = eye(length(u),length(u));
      grad_old = grad(u,[x1 x2],params,data);
    else
      grad_curr = grad(u,[x1 x2],params,data);
      s = u - u_old;
      y = grad_curr - grad_old;
      grad_old = grad_curr;
      r = 1/(y'*s);
      D = (eye(length(u),length(u))-r*s*y')*D*(eye(length(u),length(u))-r*y*s')+r*s*s';
    end
    d = -D*grad(u,[x1 x2],params,data);
    
end
