% output_final.m
%
% Final output for
%  * convergence analysis (gradient-based methods)
%  * stepsize search
%
% for 13_opt_lotka_volterra.m
%

figure(2);
if (BigFigure)
  set(gcf, 'Units', 'Normalized', 'OuterPosition', [0 0 1 1]);
end

% convergence analysis
if (~isempty(uAll))
  ee = [];
  for ii=1:size(uAll,1)-1
    if norm(uAll(ii,:)-uAll(end,:),2) > 1e-8
      ee = [ee norm(uAll(ii,:)-uAll(end,:),2)];
    end
  end
  if length(ee)>3
    subplot(1,2,1); 
    x = log10(ee(1:end-1)); y = log10(ee(2:end));
    pft = polyfit(x,y,1); xx = min(x):0.001:max(x); yy = polyval(pft,xx);
    plot(xx,yy,'-r', 'LineWidth',2.5); hold on; plot(x,y,'b.','MarkerSize',20);
    set(gca,'FontSize',FontSize); box off;
    xlabel('log_{10} |e^k|','FontSize',FontSize); ylabel('log_{10} |e^{k+1}|','FontSize',FontSize);
    title([method ': r = ' num2str(pft(1)) ', C = ' num2str(10^pft(2))],'FontSize',FontSize);
  end
end

% stepsize search
subplot(1,2,2);
semilogy(0:length(alpha)-1,abs(alpha),'b.','MarkerSize',MarkerSizeSmall); hold on;
title(['stepsize (log-scaled), \alpha =' num2str(alpha(end))],'FontSize',FontSize);
xlabel('iterations, k','FontSize',FontSize); set(gca,'FontSize',FontSize); box off;
