% mode_OPT.m
%
% OPTimization mode for opt_lotka_volterra.m
%

% main OPTimization loop for gradient-based methods
while(k < kMax+1) % termination condition #3

  % J-evaluation
  [objCurr,x1,x2] = f(0.0, u, zeros(size(u)), params, data);
  obj = [obj objCurr];
  
  % saving initial solution for visualization
  if k==0; x10 = x1; x20 = x2; end;

  % visualization
  visualize;

  % termination condition #1: checking optimality (objective change)
  if k > 0
    err1 = abs(obj(end-1)-obj(end))/obj(end-1);
    if (err1 < epsilonF)
      exCode = 1;
      break;
    end
  end

  % termination condition #2: checking optimality (solution change)
  if k > 0
    err2 = norm(u-u_old,2)/norm(u_old,2);
    if (err2 < epsilonA)
      exCode = 2;
      break;
    end
  end

  % choosing main solution method
  switch method
    
    % available methods
    case {'SD', 'CG', 'BFGS'}
      search_direction; % search for update direction d
      search_stepsize;  % search for stepsize alpha
      alpha = [alpha alphaOpt];
    
    otherwise
      disp(['error (OPT): Unknown method ' method ' is chosen!']);
      exCode = 0; % termination due to error
      return;

  end
  
  % update for controls
  u_old = u;
  u = u + alphaOpt*d;
  uAll = [uAll; u']; % for convergence analysis
   
  % iteration counter increment
  k = k + 1;

end

if exCode==3; k = k - 1; end;
