% kappa_test.m
%
% for opt_lotka_volterra.m
%

% Kappa-test #1: cheap test
for k = 1:16
  eps(k) = 10^(k-16);
  kappaC(k) = (f(eps(k), u, u, params, data)-obj)/(eps(k)*trapz(tt,d.*u));
end

% Kappa-test #2: expensive test
epS = 10^-6;
for i = 1:length(u)-1
  u_new = zeros(size(u)); u_new(i) = u(i);
  kappaE(i) = (f(epS, u, u_new, params, data)-obj)/(epS*d(i)*u(i)*ht);
end

% visualization for cheap kappa-test #1
figure(1);
semilogx(eps,kappaC,'r.-','MarkerSize',MarkerSizeSmall,'LineWidth', LineWidth); hold on;
plot([eps(1) eps(end)], [1 1], '--k'); axis([eps(1) eps(end) 0.95 1.05]);
xlabel('\epsilon','FontSize',FontSize); ylabel('\kappa(\epsilon)','FontSize',FontSize);
title('kappa-test (cheap)','FontSize',FontSize);
set(gca,'FontSize',FontSize-2); box off;

figure(2);
loglog(eps,abs(kappaC-1),'r.-','MarkerSize',MarkerSizeSmall,'LineWidth', LineWidth); hold on;
xlabel('\epsilon','FontSize',FontSize); ylabel('| \kappa(\epsilon) - 1|','FontSize',FontSize);
title('kappa-test (cheap)','FontSize',FontSize);
set(gca,'XLim',[eps(1) eps(end)],'FontSize',FontSize-2); box off;

% visualization for expensive kappa-test #2
figure(3);
plot(1:length(kappaE),kappaE,'r.','MarkerSize',MarkerSizeSmall);  hold on; plot([0 length(kappaE)], [1 1], '--k');
xlabel('control/gradient component #, i','FontSize',FontSize); ylabel('\kappa(i)','FontSize',FontSize);
title('kappa-test (expensive)','FontSize',FontSize); set(gca,'FontSize',FontSize-2); box off;
