% initialize.m
%
% Initialization procedure for opt_lotka_volterra.m
%

% initializing MODEL
% t-domain
ht = (tf - ti)/Nt;               % step size in t-domain
tt = (ti:ht:tf)';                % t-domain vectorization

% initializing u_ex (for measurements and visualization)
models_ctrl;

% initializing initial guess u_ini
u_ini = u_ini*ones(Nt+1,1);      % vectorization of u_ini(t)
u = u_ini;                       % setting u_0 = u_ini
uAll = u';                       % collected solutions for convergence analysis

% creating vectors of parameters (to pass into m-functions)
params = [paramsODE x1i x2i objWeight];

% initializing variables and vectors
k = 0;               % number of iterations
obj = [];            % objective function evaluations
alpha = [];          % stepsize records
exCode = 3;          % OPT termination condition (#1, #2 or #3)

% initializing golden section search parameters (if GS is chosen)
if strcmp(methodAlpha,'GS')
  alphaGS = (-1+sqrt(5))/2;
  if (alphaEps <= 0) || (alphaEps >alphaB-alphaA); disp('Incorrect epsilon!!!'); return; end;
end

% function handlers
f           = @fn_eval_obj;       % for objective function
grad        = @fn_eval_grad;      % for gradient


