% golden_section_search.m
%
% Algorithm for stepsize search:
% - Golden Section Search
% - used for opt_lotka_volterra.m
%

% new variables for a & b as alphaA, alphaB should be preserved for future use!
aa = alphaA; bb = alphaB;

% setting initial values for k, d
kk = 1; dd = bb - aa;

% 1st approximation for optimal solution
alphaOpt = (aa+bb)/2;

% search loop
while(dd >= alphaEps)  % termination criterion
  GSx1 = alphaGS*aa + (1-alphaGS)*bb;
  GSx2 = (1-alphaGS)*aa + alphaGS*bb;
  if kk == 1
    f1 = f(GSx1,u,d,params,data); f2 = f(GSx2,u,d,params,data); % objective function calls
    if (f1 <= f2)
      bb = GSx2; alphaOpt = GSx1;
    else
      aa = GSx1; alphaOpt = GSx2;
    end
    dd = bb-aa;
  elseif kk > 1
    if abs(GSx2-alphaOpt)<abs(GSx1-alphaOpt)
      f2 = f1; f1 = f(GSx1,u,d,params,data); % objective function call
    else
      f1 = f2; f2 = f(GSx2,u,d,params,data); % objective function call
    end
    if (f1 <= f2)
      bb = GSx2; alphaOpt = GSx1;
    else
      aa = GSx1; alphaOpt = GSx2;
    end
    dd = bb-aa;
  end

  kk = kk + 1;
  
end
