public class Paddle implements Hittable, Moveable
{
	private int location, xLocation, width, height, tY, bY, lX, rX, xP, yP, xD, yD;

	public Paddle(int l, int xL, int x, int y)
	{
		location=l;
		xLocation=xL;
		width=x;
		height=y;
		tY=l;
		bY=l+y;
		lX=xL;
		rX=xL+x;
		xP=0;
		yP=0;
		xD=1;
		yD=1;
	}

	/**
	* returns the Y value of the highest pixel in the object
	*/
	public int topY()
	{
		return tY;
	}

	/**
	* returns the Y value of the lowest pixel in the object
	*/
	public int bottomY()
	{
		return bY;
	}

	/**
	* returns the X value of the LeftMost pixel in the object
	*/
	public int leftX()
	{
		return lX;
	}

	/**
	* returns the X value of the Rightmost pixel in the object
	*/
	public int rightX()
	{
		return rX;
	}

	/**
	* returns the y coordinate of the object
	*/
	public int getLocation()
	{
		return location;
	}

	/**
	* returns the x coordinate of the object
	*/
	public int getXLocation()
	{
		return xLocation;
	}

	public int getWidth()
	{
		return width;
	}

	public int getHeight()
	{
		return height;
	}

	public void setLocation(int l)
	{
		location=l;
		setVars();
	}

	public void setXLocation(int l)
	{
		xLocation=l;
		setVars();
	}

	public void setWidth(int w)
	{
		width=w;
		setVars();
	}

	public void setHeight(int h)
	{
		height=h;
		setVars();
	}

	private void setVars()
	{
		tY=location;
		bY=location+height;
		lX=xLocation;
		rX=xLocation+width;
	}

	/**
	* COMMENT COMMENT  COMMENT COMMENT
	* COMMENT COMMENT  COMMENT COMMENT
	* COMMENT COMMENT  COMMENT COMMENT
	* COMMENT COMMENT  COMMENT COMMENT
	* COMMENT COMMENT  COMMENT COMMENT
	* COMMENT COMMENT  COMMENT COMMENT
	* COMMENT COMMENT  COMMENT COMMENT
	* COMMENT COMMENT  COMMENT COMMENT
	* COMMENT COMMENT  COMMENT COMMENT
	* COMMENT COMMENT  COMMENT COMMENT
	*/
	public boolean isContacting(Hittable a)
	{
		if((a.leftX()<=rightX())&&(a.leftX()>=leftX()))
		{
			if((a.topY()<=bottomY())&&(a.topY()>=topY()))
			{
				return true;
			}
			if((a.bottomY()<=bottomY())&&(a.bottomY()>=topY()))
			{
				return true;
			}
			return false;
		}
		if((a.rightX()<=rightX())&&(a.rightX()>=leftX()))
		{
			if((a.topY()<=bottomY())&&(a.topY()>=topY()))
			{
				return true;
			}
			if((a.bottomY()<=bottomY())&&(a.bottomY()>=topY()))
			{
				return true;
			}
			return false;
		}
		return false;
	}

	public void moveX()
	{
		if(xP>(int)(Math.random()*1000))
		{
			setXLocation(xLocation+xD);
		}
	}

	public void moveY()
	{
		if(yP>(int)(Math.random()*1000))
		{
			setLocation(location-yD);
		}
	}

	public void setXD(int d)
	{
		xD=d;
	}

	public void setYD(int d)
	{
		yD=d;
	}

	public void setXP(int p)
	{
		xP=p;
	}

	public void setYP(int p)
	{
		yP=p;
	}

	public int getXP()
	{
		return xP;
	}

	public int getYP()
	{
		return yP;
	}
}

