import java.awt.*;

public class Ball implements Hittable, Moveable
{
	private int location, xLocation, width, tY, bY, lX, rX, xD,yD, xP, yP;
	private Color c;

	public Ball(int l, int xL, int x)
	{
		location=l;
		xLocation=xL;
		width=x;
		tY=l;
		bY=l+x;
		lX=xL;
		rX=xL+x;
		xD=-1;
		yD=1;
		xP=0;
		yP=0;
		c=Color.red;
	}

	public int topY()
	{
		return tY;
	}

	public int bottomY()
	{
		return bY;
	}

	public int leftX()
	{
		return lX;
	}

	public int rightX()
	{
		return rX;
	}

	public int getLocation()
	{
		return location;
	}

	public int getXLocation()
	{
		return xLocation;
	}

	public int getWidth()
	{
		return width;
	}

	public void setLocation(int l)
	{
		location=l;
		setVars();
	}

	public void setXLocation(int l)
	{
		xLocation=l;
		setVars();
	}

	public void setWidth(int w)
	{
		width=w;
		setVars();
	}

	private void setVars()
	{
		tY=location;
		bY=location+width;
		lX=xLocation;
		rX=xLocation+width;
	}

	public boolean isContacting(Hittable a)
	{
		if((a.leftX()<=rightX())&&(a.leftX()>=leftX()))
		{
			if((a.topY()<=bottomY())&&(a.topY()>=topY()))
			{
				return true;
			}
			if((a.bottomY()<=bottomY())&&(a.bottomY()>=topY()))
			{
				return true;
			}
			return false;
		}
		if((a.rightX()<=rightX())&&(a.rightX()>=leftX()))
		{
			if((a.topY()<=bottomY())&&(a.topY()>=topY()))
			{
				return true;
			}
			if((a.bottomY()<=bottomY())&&(a.bottomY()>=topY()))
			{
				return true;
			}
			return false;
		}
		return false;
	}

	public void moveX()
	{
		if(xP>(int)(Math.random()*1000))
		{
			setXLocation(xLocation+xD);
		}
	}

	public void moveY()
	{
		if(yP>(int)(Math.random()*1000))
		{
			setLocation(location-yD);
		}
	}

	public void setXD(int d)
	{
		xD=d;
	}

	public void setYD(int d)
	{
		yD=d;
	}

	public void setXP(int p)
	{
		xP=p;
	}

	public void setYP(int p)
	{
		yP=p;
	}

	public int getXP()
	{
		return xP;
	}

	public int getYP()
	{
		return yP;
	}

	public int getXD()
	{
		return xD;
	}

	public Color getColor()
	{
		return c;
	}

	public void setColor(Color d)
	{
		c=d;
	}
}