create table svngroups (
   svngroup varchar(64),
   svnmember varchar(256),
   unique (svngroup, svnmember)
);

create table svnauthz (
   regex char(1)
      default 'f'
      check (
         regex in ('f', 't')
      )
   ,
   repository varchar(64)
      check (
         repository not similar to '(%[/: \t\n]%)'
      )
   ,
   path varchar(512)
      check (
         path not similar to '(%[:\t\n]%|%//%|%/./%|%/.|/../|%/..)'
      )
   ,
   entity varchar(256),
   access int
      default 0
      check (
         access >= 0 and access < 3
   )
   ,
   unique (
      regex, repository, path, entity, access
   )
);
