#! /bin/bash

sudo -u postgres dropdb --interactive svndb
sudo -u postgres dropuser --interactive svn
sudo -u postgres createuser \
   --echo --no-superuser --no-createdb --no-createrole svn
sudo -u postgres createdb --echo --owner=svn svndb
echo
echo "You must edit the access rules for connecting to the svndb database."
echo \
   "For example, add the following line to pg_hba.conf before any deny rules:"
echo "   local svndb svn trust"
echo
read -e -p "Open pg_hba.conf for editing(Y/n)?: " -n 1 ANS
if (! ([ $ANS == "n" ] || [ $ANS == "N" ])); then
   vim ~postgres/data/pg_hba.conf
   clear
   service postgresql reload
fi
psql -a -f svndb.sql svndb svn
